package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecRuleArgs private(
  conditionException: Output[Option[String]],
  configId: Output[Int],
  ruleAction: Output[Option[String]],
  ruleId: Output[Int],
  securityPolicyId: Output[String]
) derives ArgsEncoder

object AppSecRuleArgs:
  def apply(
    conditionException: Input.Optional[String] = None,
    configId: Input[Int],
    ruleAction: Input.Optional[String] = None,
    ruleId: Input[Int],
    securityPolicyId: Input[String]
  )(using Context): AppSecRuleArgs =
    new AppSecRuleArgs(
      conditionException = conditionException.asOptionOutput(isSecret = false),
      configId = configId.asOutput(isSecret = false),
      ruleAction = ruleAction.asOptionOutput(isSecret = false),
      ruleId = ruleId.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false)
    )
