package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecRuleUpgrade private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  currentRuleset: Output[String],
  evalStatus: Output[String],
  mode: Output[String],
  securityPolicyId: Output[String],
  upgradeMode: Output[Option[String]]
) extends CustomResource derives ResourceDecoder

object AppSecRuleUpgrade:
  given outputOps: {} with
    extension(output: Output[AppSecRuleUpgrade])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def currentRuleset: Output[String] = output.flatMap(_.currentRuleset)
      def evalStatus: Output[String] = output.flatMap(_.evalStatus)
      def mode: Output[String] = output.flatMap(_.mode)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)
      def upgradeMode: Output[Option[String]] = output.flatMap(_.upgradeMode)

def appSecRuleUpgrade(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecRuleUpgradeArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecRuleUpgrade] = 
  ctx.registerResource[AppSecRuleUpgrade, AppSecRuleUpgradeArgs]("akamai:index/appSecRuleUpgrade:AppSecRuleUpgrade", name, args, opts)

