package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecRuleUpgradeArgs private(
  configId: Output[Int],
  securityPolicyId: Output[String],
  upgradeMode: Output[Option[String]]
) derives ArgsEncoder

object AppSecRuleUpgradeArgs:
  def apply(
    configId: Input[Int],
    securityPolicyId: Input[String],
    upgradeMode: Input.Optional[String] = None
  )(using Context): AppSecRuleUpgradeArgs =
    new AppSecRuleUpgradeArgs(
      configId = configId.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false),
      upgradeMode = upgradeMode.asOptionOutput(isSecret = false)
    )
