package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecSecurityPolicy private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  createFromSecurityPolicyId: Output[Option[String]],
  defaultSettings: Output[Option[Boolean]],
  securityPolicyId: Output[String],
  securityPolicyName: Output[String],
  securityPolicyPrefix: Output[String]
) extends CustomResource derives ResourceDecoder

object AppSecSecurityPolicy:
  given outputOps: {} with
    extension(output: Output[AppSecSecurityPolicy])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def createFromSecurityPolicyId: Output[Option[String]] = output.flatMap(_.createFromSecurityPolicyId)
      def defaultSettings: Output[Option[Boolean]] = output.flatMap(_.defaultSettings)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)
      def securityPolicyName: Output[String] = output.flatMap(_.securityPolicyName)
      def securityPolicyPrefix: Output[String] = output.flatMap(_.securityPolicyPrefix)

def appSecSecurityPolicy(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecSecurityPolicyArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecSecurityPolicy] = 
  ctx.registerResource[AppSecSecurityPolicy, AppSecSecurityPolicyArgs]("akamai:index/appSecSecurityPolicy:AppSecSecurityPolicy", name, args, opts)

