package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecSecurityPolicyArgs private(
  configId: Output[Int],
  createFromSecurityPolicyId: Output[Option[String]],
  defaultSettings: Output[Option[Boolean]],
  securityPolicyName: Output[String],
  securityPolicyPrefix: Output[String]
) derives ArgsEncoder

object AppSecSecurityPolicyArgs:
  def apply(
    configId: Input[Int],
    createFromSecurityPolicyId: Input.Optional[String] = None,
    defaultSettings: Input.Optional[Boolean] = None,
    securityPolicyName: Input[String],
    securityPolicyPrefix: Input[String]
  )(using Context): AppSecSecurityPolicyArgs =
    new AppSecSecurityPolicyArgs(
      configId = configId.asOutput(isSecret = false),
      createFromSecurityPolicyId = createFromSecurityPolicyId.asOptionOutput(isSecret = false),
      defaultSettings = defaultSettings.asOptionOutput(isSecret = false),
      securityPolicyName = securityPolicyName.asOutput(isSecret = false),
      securityPolicyPrefix = securityPolicyPrefix.asOutput(isSecret = false)
    )
