package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecSecurityPolicyRename private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  securityPolicyId: Output[String],
  securityPolicyName: Output[String]
) extends CustomResource derives ResourceDecoder

object AppSecSecurityPolicyRename:
  given outputOps: {} with
    extension(output: Output[AppSecSecurityPolicyRename])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)
      def securityPolicyName: Output[String] = output.flatMap(_.securityPolicyName)

def appSecSecurityPolicyRename(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecSecurityPolicyRenameArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecSecurityPolicyRename] = 
  ctx.registerResource[AppSecSecurityPolicyRename, AppSecSecurityPolicyRenameArgs]("akamai:index/appSecSecurityPolicyRename:AppSecSecurityPolicyRename", name, args, opts)

