package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecSecurityPolicyRenameArgs private(
  configId: Output[Int],
  securityPolicyId: Output[String],
  securityPolicyName: Output[String]
) derives ArgsEncoder

object AppSecSecurityPolicyRenameArgs:
  def apply(
    configId: Input[Int],
    securityPolicyId: Input[String],
    securityPolicyName: Input[String]
  )(using Context): AppSecSecurityPolicyRenameArgs =
    new AppSecSecurityPolicyRenameArgs(
      configId = configId.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false),
      securityPolicyName = securityPolicyName.asOutput(isSecret = false)
    )
