package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecSelectedHostnames private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  hostnames: Output[scala.collection.immutable.List[String]],
  mode: Output[String]
) extends CustomResource derives ResourceDecoder

object AppSecSelectedHostnames:
  given outputOps: {} with
    extension(output: Output[AppSecSelectedHostnames])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def hostnames: Output[scala.collection.immutable.List[String]] = output.flatMap(_.hostnames)
      def mode: Output[String] = output.flatMap(_.mode)

def appSecSelectedHostnames(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecSelectedHostnamesArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecSelectedHostnames] = 
  ctx.registerResource[AppSecSelectedHostnames, AppSecSelectedHostnamesArgs]("akamai:index/appSecSelectedHostnames:AppSecSelectedHostnames", name, args, opts)

