package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecSelectedHostnamesArgs private(
  configId: Output[Int],
  hostnames: Output[scala.collection.immutable.List[String]],
  mode: Output[String]
) derives ArgsEncoder

object AppSecSelectedHostnamesArgs:
  def apply(
    configId: Input[Int],
    hostnames: Input[List[Input[String]]],
    mode: Input[String]
  )(using Context): AppSecSelectedHostnamesArgs =
    new AppSecSelectedHostnamesArgs(
      configId = configId.asOutput(isSecret = false),
      hostnames = hostnames.asOutput(isSecret = false),
      mode = mode.asOutput(isSecret = false)
    )
