package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecSiemSettings private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  enableBotmanSiem: Output[Boolean],
  enableForAllPolicies: Output[Boolean],
  enableSiem: Output[Boolean],
  securityPolicyIds: Output[Option[scala.collection.immutable.List[String]]],
  siemId: Output[Int]
) extends CustomResource derives ResourceDecoder

object AppSecSiemSettings:
  given outputOps: {} with
    extension(output: Output[AppSecSiemSettings])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def enableBotmanSiem: Output[Boolean] = output.flatMap(_.enableBotmanSiem)
      def enableForAllPolicies: Output[Boolean] = output.flatMap(_.enableForAllPolicies)
      def enableSiem: Output[Boolean] = output.flatMap(_.enableSiem)
      def securityPolicyIds: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.securityPolicyIds)
      def siemId: Output[Int] = output.flatMap(_.siemId)

def appSecSiemSettings(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecSiemSettingsArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecSiemSettings] = 
  ctx.registerResource[AppSecSiemSettings, AppSecSiemSettingsArgs]("akamai:index/appSecSiemSettings:AppSecSiemSettings", name, args, opts)

