package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecSiemSettingsArgs private(
  configId: Output[Int],
  enableBotmanSiem: Output[Boolean],
  enableForAllPolicies: Output[Boolean],
  enableSiem: Output[Boolean],
  securityPolicyIds: Output[Option[scala.collection.immutable.List[String]]],
  siemId: Output[Int]
) derives ArgsEncoder

object AppSecSiemSettingsArgs:
  def apply(
    configId: Input[Int],
    enableBotmanSiem: Input[Boolean],
    enableForAllPolicies: Input[Boolean],
    enableSiem: Input[Boolean],
    securityPolicyIds: Input.Optional[List[Input[String]]] = None,
    siemId: Input[Int]
  )(using Context): AppSecSiemSettingsArgs =
    new AppSecSiemSettingsArgs(
      configId = configId.asOutput(isSecret = false),
      enableBotmanSiem = enableBotmanSiem.asOutput(isSecret = false),
      enableForAllPolicies = enableForAllPolicies.asOutput(isSecret = false),
      enableSiem = enableSiem.asOutput(isSecret = false),
      securityPolicyIds = securityPolicyIds.asOptionOutput(isSecret = false),
      siemId = siemId.asOutput(isSecret = false)
    )
