package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecSlowPost private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  durationThresholdTimeout: Output[Option[Int]],
  securityPolicyId: Output[String],
  slowRateAction: Output[String],
  slowRateThresholdPeriod: Output[Option[Int]],
  slowRateThresholdRate: Output[Option[Int]]
) extends CustomResource derives ResourceDecoder

object AppSecSlowPost:
  given outputOps: {} with
    extension(output: Output[AppSecSlowPost])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def durationThresholdTimeout: Output[Option[Int]] = output.flatMap(_.durationThresholdTimeout)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)
      def slowRateAction: Output[String] = output.flatMap(_.slowRateAction)
      def slowRateThresholdPeriod: Output[Option[Int]] = output.flatMap(_.slowRateThresholdPeriod)
      def slowRateThresholdRate: Output[Option[Int]] = output.flatMap(_.slowRateThresholdRate)

def appSecSlowPost(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecSlowPostArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecSlowPost] = 
  ctx.registerResource[AppSecSlowPost, AppSecSlowPostArgs]("akamai:index/appSecSlowPost:AppSecSlowPost", name, args, opts)

