package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecSlowPostArgs private(
  configId: Output[Int],
  durationThresholdTimeout: Output[Option[Int]],
  securityPolicyId: Output[String],
  slowRateAction: Output[String],
  slowRateThresholdPeriod: Output[Option[Int]],
  slowRateThresholdRate: Output[Option[Int]]
) derives ArgsEncoder

object AppSecSlowPostArgs:
  def apply(
    configId: Input[Int],
    durationThresholdTimeout: Input.Optional[Int] = None,
    securityPolicyId: Input[String],
    slowRateAction: Input[String],
    slowRateThresholdPeriod: Input.Optional[Int] = None,
    slowRateThresholdRate: Input.Optional[Int] = None
  )(using Context): AppSecSlowPostArgs =
    new AppSecSlowPostArgs(
      configId = configId.asOutput(isSecret = false),
      durationThresholdTimeout = durationThresholdTimeout.asOptionOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false),
      slowRateAction = slowRateAction.asOutput(isSecret = false),
      slowRateThresholdPeriod = slowRateThresholdPeriod.asOptionOutput(isSecret = false),
      slowRateThresholdRate = slowRateThresholdRate.asOptionOutput(isSecret = false)
    )
