package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecThreatIntel private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  securityPolicyId: Output[String],
  threatIntel: Output[String]
) extends CustomResource derives ResourceDecoder

object AppSecThreatIntel:
  given outputOps: {} with
    extension(output: Output[AppSecThreatIntel])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)
      def threatIntel: Output[String] = output.flatMap(_.threatIntel)

def appSecThreatIntel(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecThreatIntelArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecThreatIntel] = 
  ctx.registerResource[AppSecThreatIntel, AppSecThreatIntelArgs]("akamai:index/appSecThreatIntel:AppSecThreatIntel", name, args, opts)

