package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecThreatIntelArgs private(
  configId: Output[Int],
  securityPolicyId: Output[String],
  threatIntel: Output[String]
) derives ArgsEncoder

object AppSecThreatIntelArgs:
  def apply(
    configId: Input[Int],
    securityPolicyId: Input[String],
    threatIntel: Input[String]
  )(using Context): AppSecThreatIntelArgs =
    new AppSecThreatIntelArgs(
      configId = configId.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false),
      threatIntel = threatIntel.asOutput(isSecret = false)
    )
