package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecVersionNodes private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  outputText: Output[String],
  versionNotes: Output[String]
) extends CustomResource derives ResourceDecoder

object AppSecVersionNodes:
  given outputOps: {} with
    extension(output: Output[AppSecVersionNodes])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def outputText: Output[String] = output.flatMap(_.outputText)
      def versionNotes: Output[String] = output.flatMap(_.versionNotes)

def appSecVersionNodes(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecVersionNodesArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecVersionNodes] = 
  ctx.registerResource[AppSecVersionNodes, AppSecVersionNodesArgs]("akamai:index/appSecVersionNodes:AppSecVersionNodes", name, args, opts)

