package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecVersionNodesArgs private(
  configId: Output[Int],
  versionNotes: Output[String]
) derives ArgsEncoder

object AppSecVersionNodesArgs:
  def apply(
    configId: Input[Int],
    versionNotes: Input[String]
  )(using Context): AppSecVersionNodesArgs =
    new AppSecVersionNodesArgs(
      configId = configId.asOutput(isSecret = false),
      versionNotes = versionNotes.asOutput(isSecret = false)
    )
