package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecWafMode private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  currentRuleset: Output[String],
  evalExpirationDate: Output[String],
  evalRuleset: Output[String],
  evalStatus: Output[String],
  mode: Output[String],
  outputText: Output[String],
  securityPolicyId: Output[String]
) extends CustomResource derives ResourceDecoder

object AppSecWafMode:
  given outputOps: {} with
    extension(output: Output[AppSecWafMode])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def currentRuleset: Output[String] = output.flatMap(_.currentRuleset)
      def evalExpirationDate: Output[String] = output.flatMap(_.evalExpirationDate)
      def evalRuleset: Output[String] = output.flatMap(_.evalRuleset)
      def evalStatus: Output[String] = output.flatMap(_.evalStatus)
      def mode: Output[String] = output.flatMap(_.mode)
      def outputText: Output[String] = output.flatMap(_.outputText)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)

def appSecWafMode(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecWafModeArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecWafMode] = 
  ctx.registerResource[AppSecWafMode, AppSecWafModeArgs]("akamai:index/appSecWafMode:AppSecWafMode", name, args, opts)

