package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecWafModeArgs private(
  configId: Output[Int],
  mode: Output[String],
  securityPolicyId: Output[String]
) derives ArgsEncoder

object AppSecWafModeArgs:
  def apply(
    configId: Input[Int],
    mode: Input[String],
    securityPolicyId: Input[String]
  )(using Context): AppSecWafModeArgs =
    new AppSecWafModeArgs(
      configId = configId.asOutput(isSecret = false),
      mode = mode.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false)
    )
