package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecWafProtection private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  enabled: Output[Boolean],
  outputText: Output[String],
  securityPolicyId: Output[String]
) extends CustomResource derives ResourceDecoder

object AppSecWafProtection:
  given outputOps: {} with
    extension(output: Output[AppSecWafProtection])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def enabled: Output[Boolean] = output.flatMap(_.enabled)
      def outputText: Output[String] = output.flatMap(_.outputText)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)

def appSecWafProtection(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecWafProtectionArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecWafProtection] = 
  ctx.registerResource[AppSecWafProtection, AppSecWafProtectionArgs]("akamai:index/appSecWafProtection:AppSecWafProtection", name, args, opts)

