package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecWafProtectionArgs private(
  configId: Output[Int],
  enabled: Output[Boolean],
  securityPolicyId: Output[String]
) derives ArgsEncoder

object AppSecWafProtectionArgs:
  def apply(
    configId: Input[Int],
    enabled: Input[Boolean],
    securityPolicyId: Input[String]
  )(using Context): AppSecWafProtectionArgs =
    new AppSecWafProtectionArgs(
      configId = configId.asOutput(isSecret = false),
      enabled = enabled.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false)
    )
