package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppSecWapSelectedHostnames private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  evaluatedHosts: Output[Option[scala.collection.immutable.List[String]]],
  protectedHosts: Output[Option[scala.collection.immutable.List[String]]],
  securityPolicyId: Output[String]
) extends CustomResource derives ResourceDecoder

object AppSecWapSelectedHostnames:
  given outputOps: {} with
    extension(output: Output[AppSecWapSelectedHostnames])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def evaluatedHosts: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.evaluatedHosts)
      def protectedHosts: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.protectedHosts)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)

def appSecWapSelectedHostnames(using ctx: Context)(
  name: NonEmptyString,
  args: AppSecWapSelectedHostnamesArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppSecWapSelectedHostnames] = 
  ctx.registerResource[AppSecWapSelectedHostnames, AppSecWapSelectedHostnamesArgs]("akamai:index/appSecWapSelectedHostnames:AppSecWapSelectedHostnames", name, args, opts)

