package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppSecWapSelectedHostnamesArgs private(
  configId: Output[Int],
  evaluatedHosts: Output[Option[scala.collection.immutable.List[String]]],
  protectedHosts: Output[Option[scala.collection.immutable.List[String]]],
  securityPolicyId: Output[String]
) derives ArgsEncoder

object AppSecWapSelectedHostnamesArgs:
  def apply(
    configId: Input[Int],
    evaluatedHosts: Input.Optional[List[Input[String]]] = None,
    protectedHosts: Input.Optional[List[Input[String]]] = None,
    securityPolicyId: Input[String]
  )(using Context): AppSecWapSelectedHostnamesArgs =
    new AppSecWapSelectedHostnamesArgs(
      configId = configId.asOutput(isSecret = false),
      evaluatedHosts = evaluatedHosts.asOptionOutput(isSecret = false),
      protectedHosts = protectedHosts.asOptionOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false)
    )
