package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppsecAdvancedSettingsAttackPayloadLogging private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  attackPayloadLogging: Output[String],
  configId: Output[Int],
  securityPolicyId: Output[Option[String]]
) extends CustomResource derives ResourceDecoder

object AppsecAdvancedSettingsAttackPayloadLogging:
  given outputOps: {} with
    extension(output: Output[AppsecAdvancedSettingsAttackPayloadLogging])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def attackPayloadLogging: Output[String] = output.flatMap(_.attackPayloadLogging)
      def configId: Output[Int] = output.flatMap(_.configId)
      def securityPolicyId: Output[Option[String]] = output.flatMap(_.securityPolicyId)

def appsecAdvancedSettingsAttackPayloadLogging(using ctx: Context)(
  name: NonEmptyString,
  args: AppsecAdvancedSettingsAttackPayloadLoggingArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppsecAdvancedSettingsAttackPayloadLogging] = 
  ctx.registerResource[AppsecAdvancedSettingsAttackPayloadLogging, AppsecAdvancedSettingsAttackPayloadLoggingArgs]("akamai:index/appsecAdvancedSettingsAttackPayloadLogging:AppsecAdvancedSettingsAttackPayloadLogging", name, args, opts)

