package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppsecAdvancedSettingsAttackPayloadLoggingArgs private(
  attackPayloadLogging: Output[String],
  configId: Output[Int],
  securityPolicyId: Output[Option[String]]
) derives ArgsEncoder

object AppsecAdvancedSettingsAttackPayloadLoggingArgs:
  def apply(
    attackPayloadLogging: Input[String],
    configId: Input[Int],
    securityPolicyId: Input.Optional[String] = None
  )(using Context): AppsecAdvancedSettingsAttackPayloadLoggingArgs =
    new AppsecAdvancedSettingsAttackPayloadLoggingArgs(
      attackPayloadLogging = attackPayloadLogging.asOutput(isSecret = false),
      configId = configId.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOptionOutput(isSecret = false)
    )
