package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppsecAdvancedSettingsPiiLearning private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  enablePiiLearning: Output[Boolean]
) extends CustomResource derives ResourceDecoder

object AppsecAdvancedSettingsPiiLearning:
  given outputOps: {} with
    extension(output: Output[AppsecAdvancedSettingsPiiLearning])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def enablePiiLearning: Output[Boolean] = output.flatMap(_.enablePiiLearning)

def appsecAdvancedSettingsPiiLearning(using ctx: Context)(
  name: NonEmptyString,
  args: AppsecAdvancedSettingsPiiLearningArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppsecAdvancedSettingsPiiLearning] = 
  ctx.registerResource[AppsecAdvancedSettingsPiiLearning, AppsecAdvancedSettingsPiiLearningArgs]("akamai:index/appsecAdvancedSettingsPiiLearning:AppsecAdvancedSettingsPiiLearning", name, args, opts)

