package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppsecAdvancedSettingsPiiLearningArgs private(
  configId: Output[Int],
  enablePiiLearning: Output[Boolean]
) derives ArgsEncoder

object AppsecAdvancedSettingsPiiLearningArgs:
  def apply(
    configId: Input[Int],
    enablePiiLearning: Input[Boolean]
  )(using Context): AppsecAdvancedSettingsPiiLearningArgs =
    new AppsecAdvancedSettingsPiiLearningArgs(
      configId = configId.asOutput(isSecret = false),
      enablePiiLearning = enablePiiLearning.asOutput(isSecret = false)
    )
