package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppsecAdvancedSettingsRequestBody private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  requestBodyInspectionLimit: Output[String],
  securityPolicyId: Output[Option[String]]
) extends CustomResource derives ResourceDecoder

object AppsecAdvancedSettingsRequestBody:
  given outputOps: {} with
    extension(output: Output[AppsecAdvancedSettingsRequestBody])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def requestBodyInspectionLimit: Output[String] = output.flatMap(_.requestBodyInspectionLimit)
      def securityPolicyId: Output[Option[String]] = output.flatMap(_.securityPolicyId)

def appsecAdvancedSettingsRequestBody(using ctx: Context)(
  name: NonEmptyString,
  args: AppsecAdvancedSettingsRequestBodyArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppsecAdvancedSettingsRequestBody] = 
  ctx.registerResource[AppsecAdvancedSettingsRequestBody, AppsecAdvancedSettingsRequestBodyArgs]("akamai:index/appsecAdvancedSettingsRequestBody:AppsecAdvancedSettingsRequestBody", name, args, opts)

