package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppsecAdvancedSettingsRequestBodyArgs private(
  configId: Output[Int],
  requestBodyInspectionLimit: Output[String],
  securityPolicyId: Output[Option[String]]
) derives ArgsEncoder

object AppsecAdvancedSettingsRequestBodyArgs:
  def apply(
    configId: Input[Int],
    requestBodyInspectionLimit: Input[String],
    securityPolicyId: Input.Optional[String] = None
  )(using Context): AppsecAdvancedSettingsRequestBodyArgs =
    new AppsecAdvancedSettingsRequestBodyArgs(
      configId = configId.asOutput(isSecret = false),
      requestBodyInspectionLimit = requestBodyInspectionLimit.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOptionOutput(isSecret = false)
    )
