package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class AppsecSecurityPolicyDefaultProtections private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  configId: Output[Int],
  securityPolicyId: Output[String],
  securityPolicyName: Output[String],
  securityPolicyPrefix: Output[String]
) extends CustomResource derives ResourceDecoder

object AppsecSecurityPolicyDefaultProtections:
  given outputOps: {} with
    extension(output: Output[AppsecSecurityPolicyDefaultProtections])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def configId: Output[Int] = output.flatMap(_.configId)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)
      def securityPolicyName: Output[String] = output.flatMap(_.securityPolicyName)
      def securityPolicyPrefix: Output[String] = output.flatMap(_.securityPolicyPrefix)

def appsecSecurityPolicyDefaultProtections(using ctx: Context)(
  name: NonEmptyString,
  args: AppsecSecurityPolicyDefaultProtectionsArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[AppsecSecurityPolicyDefaultProtections] = 
  ctx.registerResource[AppsecSecurityPolicyDefaultProtections, AppsecSecurityPolicyDefaultProtectionsArgs]("akamai:index/appsecSecurityPolicyDefaultProtections:AppsecSecurityPolicyDefaultProtections", name, args, opts)

