package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class AppsecSecurityPolicyDefaultProtectionsArgs private(
  configId: Output[Int],
  securityPolicyName: Output[String],
  securityPolicyPrefix: Output[String]
) derives ArgsEncoder

object AppsecSecurityPolicyDefaultProtectionsArgs:
  def apply(
    configId: Input[Int],
    securityPolicyName: Input[String],
    securityPolicyPrefix: Input[String]
  )(using Context): AppsecSecurityPolicyDefaultProtectionsArgs =
    new AppsecSecurityPolicyDefaultProtectionsArgs(
      configId = configId.asOutput(isSecret = false),
      securityPolicyName = securityPolicyName.asOutput(isSecret = false),
      securityPolicyPrefix = securityPolicyPrefix.asOutput(isSecret = false)
    )
