package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class BotmanAkamaiBotCategoryAction private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  akamaiBotCategoryAction: Output[String],
  categoryId: Output[String],
  configId: Output[Int],
  securityPolicyId: Output[String]
) extends CustomResource derives ResourceDecoder

object BotmanAkamaiBotCategoryAction:
  given outputOps: {} with
    extension(output: Output[BotmanAkamaiBotCategoryAction])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def akamaiBotCategoryAction: Output[String] = output.flatMap(_.akamaiBotCategoryAction)
      def categoryId: Output[String] = output.flatMap(_.categoryId)
      def configId: Output[Int] = output.flatMap(_.configId)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)

def botmanAkamaiBotCategoryAction(using ctx: Context)(
  name: NonEmptyString,
  args: BotmanAkamaiBotCategoryActionArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[BotmanAkamaiBotCategoryAction] = 
  ctx.registerResource[BotmanAkamaiBotCategoryAction, BotmanAkamaiBotCategoryActionArgs]("akamai:index/botmanAkamaiBotCategoryAction:BotmanAkamaiBotCategoryAction", name, args, opts)

