package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class BotmanAkamaiBotCategoryActionArgs private(
  akamaiBotCategoryAction: Output[String],
  categoryId: Output[String],
  configId: Output[Int],
  securityPolicyId: Output[String]
) derives ArgsEncoder

object BotmanAkamaiBotCategoryActionArgs:
  def apply(
    akamaiBotCategoryAction: Input[String],
    categoryId: Input[String],
    configId: Input[Int],
    securityPolicyId: Input[String]
  )(using Context): BotmanAkamaiBotCategoryActionArgs =
    new BotmanAkamaiBotCategoryActionArgs(
      akamaiBotCategoryAction = akamaiBotCategoryAction.asOutput(isSecret = false),
      categoryId = categoryId.asOutput(isSecret = false),
      configId = configId.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false)
    )
