package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class BotmanBotAnalyticsCookie private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  botAnalyticsCookie: Output[String],
  configId: Output[Int]
) extends CustomResource derives ResourceDecoder

object BotmanBotAnalyticsCookie:
  given outputOps: {} with
    extension(output: Output[BotmanBotAnalyticsCookie])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def botAnalyticsCookie: Output[String] = output.flatMap(_.botAnalyticsCookie)
      def configId: Output[Int] = output.flatMap(_.configId)

def botmanBotAnalyticsCookie(using ctx: Context)(
  name: NonEmptyString,
  args: BotmanBotAnalyticsCookieArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[BotmanBotAnalyticsCookie] = 
  ctx.registerResource[BotmanBotAnalyticsCookie, BotmanBotAnalyticsCookieArgs]("akamai:index/botmanBotAnalyticsCookie:BotmanBotAnalyticsCookie", name, args, opts)

