package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class BotmanBotAnalyticsCookieArgs private(
  botAnalyticsCookie: Output[String],
  configId: Output[Int]
) derives ArgsEncoder

object BotmanBotAnalyticsCookieArgs:
  def apply(
    botAnalyticsCookie: Input[String],
    configId: Input[Int]
  )(using Context): BotmanBotAnalyticsCookieArgs =
    new BotmanBotAnalyticsCookieArgs(
      botAnalyticsCookie = botAnalyticsCookie.asOutput(isSecret = false),
      configId = configId.asOutput(isSecret = false)
    )
