package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class BotmanBotCategoryException private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  botCategoryException: Output[String],
  configId: Output[Int],
  securityPolicyId: Output[String]
) extends CustomResource derives ResourceDecoder

object BotmanBotCategoryException:
  given outputOps: {} with
    extension(output: Output[BotmanBotCategoryException])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def botCategoryException: Output[String] = output.flatMap(_.botCategoryException)
      def configId: Output[Int] = output.flatMap(_.configId)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)

def botmanBotCategoryException(using ctx: Context)(
  name: NonEmptyString,
  args: BotmanBotCategoryExceptionArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[BotmanBotCategoryException] = 
  ctx.registerResource[BotmanBotCategoryException, BotmanBotCategoryExceptionArgs]("akamai:index/botmanBotCategoryException:BotmanBotCategoryException", name, args, opts)

