package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class BotmanBotCategoryExceptionArgs private(
  botCategoryException: Output[String],
  configId: Output[Int],
  securityPolicyId: Output[String]
) derives ArgsEncoder

object BotmanBotCategoryExceptionArgs:
  def apply(
    botCategoryException: Input[String],
    configId: Input[Int],
    securityPolicyId: Input[String]
  )(using Context): BotmanBotCategoryExceptionArgs =
    new BotmanBotCategoryExceptionArgs(
      botCategoryException = botCategoryException.asOutput(isSecret = false),
      configId = configId.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false)
    )
