package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class BotmanBotDetectionAction private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  botDetectionAction: Output[String],
  configId: Output[Int],
  detectionId: Output[String],
  securityPolicyId: Output[String]
) extends CustomResource derives ResourceDecoder

object BotmanBotDetectionAction:
  given outputOps: {} with
    extension(output: Output[BotmanBotDetectionAction])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def botDetectionAction: Output[String] = output.flatMap(_.botDetectionAction)
      def configId: Output[Int] = output.flatMap(_.configId)
      def detectionId: Output[String] = output.flatMap(_.detectionId)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)

def botmanBotDetectionAction(using ctx: Context)(
  name: NonEmptyString,
  args: BotmanBotDetectionActionArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[BotmanBotDetectionAction] = 
  ctx.registerResource[BotmanBotDetectionAction, BotmanBotDetectionActionArgs]("akamai:index/botmanBotDetectionAction:BotmanBotDetectionAction", name, args, opts)

