package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class BotmanBotDetectionActionArgs private(
  botDetectionAction: Output[String],
  configId: Output[Int],
  detectionId: Output[String],
  securityPolicyId: Output[String]
) derives ArgsEncoder

object BotmanBotDetectionActionArgs:
  def apply(
    botDetectionAction: Input[String],
    configId: Input[Int],
    detectionId: Input[String],
    securityPolicyId: Input[String]
  )(using Context): BotmanBotDetectionActionArgs =
    new BotmanBotDetectionActionArgs(
      botDetectionAction = botDetectionAction.asOutput(isSecret = false),
      configId = configId.asOutput(isSecret = false),
      detectionId = detectionId.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false)
    )
