package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class BotmanBotManagementSettings private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  botManagementSettings: Output[String],
  configId: Output[Int],
  securityPolicyId: Output[String]
) extends CustomResource derives ResourceDecoder

object BotmanBotManagementSettings:
  given outputOps: {} with
    extension(output: Output[BotmanBotManagementSettings])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def botManagementSettings: Output[String] = output.flatMap(_.botManagementSettings)
      def configId: Output[Int] = output.flatMap(_.configId)
      def securityPolicyId: Output[String] = output.flatMap(_.securityPolicyId)

def botmanBotManagementSettings(using ctx: Context)(
  name: NonEmptyString,
  args: BotmanBotManagementSettingsArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[BotmanBotManagementSettings] = 
  ctx.registerResource[BotmanBotManagementSettings, BotmanBotManagementSettingsArgs]("akamai:index/botmanBotManagementSettings:BotmanBotManagementSettings", name, args, opts)

