package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class BotmanBotManagementSettingsArgs private(
  botManagementSettings: Output[String],
  configId: Output[Int],
  securityPolicyId: Output[String]
) derives ArgsEncoder

object BotmanBotManagementSettingsArgs:
  def apply(
    botManagementSettings: Input[String],
    configId: Input[Int],
    securityPolicyId: Input[String]
  )(using Context): BotmanBotManagementSettingsArgs =
    new BotmanBotManagementSettingsArgs(
      botManagementSettings = botManagementSettings.asOutput(isSecret = false),
      configId = configId.asOutput(isSecret = false),
      securityPolicyId = securityPolicyId.asOutput(isSecret = false)
    )
