package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class BotmanChallengeAction private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  actionId: Output[String],
  challengeAction: Output[String],
  configId: Output[Int]
) extends CustomResource derives ResourceDecoder

object BotmanChallengeAction:
  given outputOps: {} with
    extension(output: Output[BotmanChallengeAction])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def actionId: Output[String] = output.flatMap(_.actionId)
      def challengeAction: Output[String] = output.flatMap(_.challengeAction)
      def configId: Output[Int] = output.flatMap(_.configId)

def botmanChallengeAction(using ctx: Context)(
  name: NonEmptyString,
  args: BotmanChallengeActionArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[BotmanChallengeAction] = 
  ctx.registerResource[BotmanChallengeAction, BotmanChallengeActionArgs]("akamai:index/botmanChallengeAction:BotmanChallengeAction", name, args, opts)

