package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class BotmanChallengeActionArgs private(
  challengeAction: Output[String],
  configId: Output[Int]
) derives ArgsEncoder

object BotmanChallengeActionArgs:
  def apply(
    challengeAction: Input[String],
    configId: Input[Int]
  )(using Context): BotmanChallengeActionArgs =
    new BotmanChallengeActionArgs(
      challengeAction = challengeAction.asOutput(isSecret = false),
      configId = configId.asOutput(isSecret = false)
    )
