package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class BotmanChallengeInjectionRules private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  challengeInjectionRules: Output[String],
  configId: Output[Int]
) extends CustomResource derives ResourceDecoder

object BotmanChallengeInjectionRules:
  given outputOps: {} with
    extension(output: Output[BotmanChallengeInjectionRules])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def challengeInjectionRules: Output[String] = output.flatMap(_.challengeInjectionRules)
      def configId: Output[Int] = output.flatMap(_.configId)

def botmanChallengeInjectionRules(using ctx: Context)(
  name: NonEmptyString,
  args: BotmanChallengeInjectionRulesArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[BotmanChallengeInjectionRules] = 
  ctx.registerResource[BotmanChallengeInjectionRules, BotmanChallengeInjectionRulesArgs]("akamai:index/botmanChallengeInjectionRules:BotmanChallengeInjectionRules", name, args, opts)

