package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class BotmanChallengeInjectionRulesArgs private(
  challengeInjectionRules: Output[String],
  configId: Output[Int]
) derives ArgsEncoder

object BotmanChallengeInjectionRulesArgs:
  def apply(
    challengeInjectionRules: Input[String],
    configId: Input[Int]
  )(using Context): BotmanChallengeInjectionRulesArgs =
    new BotmanChallengeInjectionRulesArgs(
      challengeInjectionRules = challengeInjectionRules.asOutput(isSecret = false),
      configId = configId.asOutput(isSecret = false)
    )
