package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class BotmanChallengeInterceptionRules private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  challengeInterceptionRules: Output[String],
  configId: Output[Int]
) extends CustomResource derives ResourceDecoder

object BotmanChallengeInterceptionRules:
  given outputOps: {} with
    extension(output: Output[BotmanChallengeInterceptionRules])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def challengeInterceptionRules: Output[String] = output.flatMap(_.challengeInterceptionRules)
      def configId: Output[Int] = output.flatMap(_.configId)

def botmanChallengeInterceptionRules(using ctx: Context)(
  name: NonEmptyString,
  args: BotmanChallengeInterceptionRulesArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[BotmanChallengeInterceptionRules] = 
  ctx.registerResource[BotmanChallengeInterceptionRules, BotmanChallengeInterceptionRulesArgs]("akamai:index/botmanChallengeInterceptionRules:BotmanChallengeInterceptionRules", name, args, opts)

