package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class BotmanChallengeInterceptionRulesArgs private(
  challengeInterceptionRules: Output[String],
  configId: Output[Int]
) derives ArgsEncoder

object BotmanChallengeInterceptionRulesArgs:
  def apply(
    challengeInterceptionRules: Input[String],
    configId: Input[Int]
  )(using Context): BotmanChallengeInterceptionRulesArgs =
    new BotmanChallengeInterceptionRulesArgs(
      challengeInterceptionRules = challengeInterceptionRules.asOutput(isSecret = false),
      configId = configId.asOutput(isSecret = false)
    )
