package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class BotmanClientSideSecurity private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  clientSideSecurity: Output[String],
  configId: Output[Int]
) extends CustomResource derives ResourceDecoder

object BotmanClientSideSecurity:
  given outputOps: {} with
    extension(output: Output[BotmanClientSideSecurity])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def clientSideSecurity: Output[String] = output.flatMap(_.clientSideSecurity)
      def configId: Output[Int] = output.flatMap(_.configId)

def botmanClientSideSecurity(using ctx: Context)(
  name: NonEmptyString,
  args: BotmanClientSideSecurityArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[BotmanClientSideSecurity] = 
  ctx.registerResource[BotmanClientSideSecurity, BotmanClientSideSecurityArgs]("akamai:index/botmanClientSideSecurity:BotmanClientSideSecurity", name, args, opts)

