package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class BotmanClientSideSecurityArgs private(
  clientSideSecurity: Output[String],
  configId: Output[Int]
) derives ArgsEncoder

object BotmanClientSideSecurityArgs:
  def apply(
    clientSideSecurity: Input[String],
    configId: Input[Int]
  )(using Context): BotmanClientSideSecurityArgs =
    new BotmanClientSideSecurityArgs(
      clientSideSecurity = clientSideSecurity.asOutput(isSecret = false),
      configId = configId.asOutput(isSecret = false)
    )
