package besom.api.akamai

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class BotmanConditionalAction private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  actionId: Output[String],
  conditionalAction: Output[String],
  configId: Output[Int]
) extends CustomResource derives ResourceDecoder

object BotmanConditionalAction:
  given outputOps: {} with
    extension(output: Output[BotmanConditionalAction])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def actionId: Output[String] = output.flatMap(_.actionId)
      def conditionalAction: Output[String] = output.flatMap(_.conditionalAction)
      def configId: Output[Int] = output.flatMap(_.configId)

def botmanConditionalAction(using ctx: Context)(
  name: NonEmptyString,
  args: BotmanConditionalActionArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[BotmanConditionalAction] = 
  ctx.registerResource[BotmanConditionalAction, BotmanConditionalActionArgs]("akamai:index/botmanConditionalAction:BotmanConditionalAction", name, args, opts)

